/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.mixin;

import com.minecraftabnormals.abnormals_core.common.world.gen.ACLayerUtil;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import java.util.List;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.layer.Layer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndBiomeProvider.class})
public abstract class EndBiomeProviderMixin
extends BiomeProvider {
    @Shadow
    @Final
    private Registry<Biome> field_242640_g;
    @Shadow
    @Final
    private Biome field_242642_j;
    @Shadow
    @Final
    private Biome field_242643_k;
    @Shadow
    @Final
    private Biome field_242645_m;
    private Layer noiseBiomeLayer;

    private EndBiomeProviderMixin(List<Biome> biomes) {
        super(biomes);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void init(Registry<Biome> lookupRegistry, long seed, CallbackInfo info) {
        this.noiseBiomeLayer = ACLayerUtil.createEndBiomeLayer(lookupRegistry, seedModifier -> new LazyAreaLayerContext(25, seed, seedModifier));
    }

    @Inject(at={@At(value="RETURN")}, method={"getNoiseBiome(III)Lnet/minecraft/world/biome/Biome;"}, cancellable=true)
    private void addEndBiomes(int x, int y, int z, CallbackInfoReturnable<Biome> info) {
        Biome newBiome;
        Biome oldBiome = (Biome)info.getReturnValue();
        if ((oldBiome == this.field_242642_j || oldBiome == this.field_242643_k || oldBiome == this.field_242645_m) && (newBiome = this.getNoiseBiome(x, z)) != this.field_242643_k) {
            info.setReturnValue((Object)newBiome);
        }
    }

    private Biome getNoiseBiome(int x, int z) {
        int biomeID = this.noiseBiomeLayer.field_215742_b.func_202678_a(x, z);
        Biome biome = (Biome)this.field_242640_g.func_148745_a(biomeID);
        if (biome == null) {
            AbnormalsCore.LOGGER.warn("Unknown end biome id: {}", (Object)biomeID);
            return this.field_242643_k;
        }
        return biome;
    }
}

